/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.internal;

import java.util.Objects;
import java.util.function.BiFunction;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.neoforge.core.internal.DeferredRegisters;
import net.blay09.mods.balm.neoforge.platform.capabilities.internal.NeoForgeBalmCapabilities;
import net.blay09.mods.balm.neoforge.platform.compatibility.energy.internal.NeoForgeEnergyStorage;
import net.blay09.mods.balm.neoforge.platform.compatibility.fluid.internal.NeoForgeFluidTank;
import net.blay09.mods.balm.neoforge.platform.event.internal.ModBusEventRegisters;
import net.blay09.mods.balm.neoforge.platform.runtime.NeoForgeLoadContext;
import net.blay09.mods.balm.neoforge.platform.runtime.internal.NeoForgeBalmRuntime;
import net.blay09.mods.balm.neoforge.world.level.levelgen.NeoForgeBalmWorldGen;
import net.blay09.mods.balm.platform.capabilities.CapabilityType;
import net.blay09.mods.balm.platform.capabilities.CommonCapabilities;
import net.blay09.mods.balm.platform.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.platform.energy.EnergyStorage;
import net.blay09.mods.balm.platform.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.platform.fluid.FluidTank;
import net.blay09.mods.balm.platform.runtime.internal.BalmLoadContexts;
import net.blay09.mods.balm.world.BalmContainerProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.item.WorldlyContainerWrapper;
import org.jspecify.annotations.Nullable;

@Mod(value="balm")
public class NeoForgeBalm {
    public NeoForgeBalm(IEventBus modBus) {
        BalmLoadContexts.register("balm", new NeoForgeLoadContext(modBus));
        ((NeoForgeBalmRuntime)Balm.getRuntime()).initializeRuntime();
        DeferredRegisters.register("balm", modBus);
        ModBusEventRegisters.register("balm", modBus);
        NeoForgeBalmWorldGen.initializeBalmBiomeModifiers(modBus);
        modBus.addListener(this::enqueueIMC);
        NeoForgeBalmCapabilities capabilities = (NeoForgeBalmCapabilities)Balm.capabilities();
        CapabilityType nativeItemHandler = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"item_handler"), Capabilities.Item.BLOCK);
        CapabilityType nativeFluidHandler = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"fluid_handler"), Capabilities.Fluid.BLOCK);
        CapabilityType nativeEnergyStorage = capabilities.addExistingType(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"energy_storage"), Capabilities.Energy.BLOCK);
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"item_handler"), nativeItemHandler, new BiFunction<BlockEntity, Direction, ResourceHandler<ItemResource>>(this){
            private boolean running;

            @Override
            public @Nullable ResourceHandler<ItemResource> apply(@Nullable BlockEntity blockEntity, @Nullable Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmContainerProvider) {
                    Container container;
                    BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                    Container container2 = container = direction != null ? containerProvider.getContainer(direction) : containerProvider.getContainer();
                    if (container instanceof WorldlyContainer) {
                        WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                        return new WorldlyContainerWrapper(worldlyContainer, direction);
                    }
                    if (container != null) {
                        return VanillaContainerWrapper.of((Container)container);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    Container container = Balm.capabilities().getCapability(blockEntity, direction, Objects.requireNonNull(CommonCapabilities.CONTAINER));
                    this.running = false;
                    if (container instanceof WorldlyContainer) {
                        WorldlyContainer worldlyContainer = (WorldlyContainer)container;
                        return new WorldlyContainerWrapper(worldlyContainer, direction);
                    }
                    if (container != null) {
                        return VanillaContainerWrapper.of((Container)container);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"fluid_handler"), nativeFluidHandler, new BiFunction<BlockEntity, Direction, ResourceHandler<FluidResource>>(this){
            private boolean running;

            @Override
            public @Nullable ResourceHandler<FluidResource> apply(@Nullable BlockEntity blockEntity, @Nullable Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmFluidTankProvider) {
                    FluidTank fluidTank;
                    BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)blockEntity;
                    FluidTank fluidTank2 = fluidTank = direction != null ? fluidTankProvider.getFluidTank(direction) : fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return new NeoForgeFluidTank(fluidTank);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    FluidTank fluidTank = Balm.capabilities().getCapability(blockEntity, direction, Objects.requireNonNull(CommonCapabilities.FLUID_TANK));
                    this.running = false;
                    if (fluidTank != null) {
                        return new NeoForgeFluidTank(fluidTank);
                    }
                }
                return null;
            }
        });
        capabilities.registerFallbackBlockEntityProvider(Identifier.fromNamespaceAndPath((String)"balm", (String)"energy_storage"), nativeEnergyStorage, new BiFunction<BlockEntity, Direction, EnergyHandler>(this){
            private boolean running;

            @Override
            public @Nullable EnergyHandler apply(@Nullable BlockEntity blockEntity, @Nullable Direction direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmEnergyStorageProvider) {
                    EnergyStorage energyStorage;
                    BalmEnergyStorageProvider energyStorageProvider = (BalmEnergyStorageProvider)blockEntity;
                    EnergyStorage energyStorage2 = energyStorage = direction != null ? energyStorageProvider.getEnergyStorage(direction) : energyStorageProvider.getEnergyStorage();
                    if (energyStorage != null) {
                        return new NeoForgeEnergyStorage(energyStorage);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    EnergyStorage energyStorage = Balm.capabilities().getCapability(blockEntity, direction, Objects.requireNonNull(CommonCapabilities.ENERGY_STORAGE));
                    this.running = false;
                    if (energyStorage != null) {
                        return new NeoForgeEnergyStorage(energyStorage);
                    }
                }
                return null;
            }
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (Balm.platform().isModLoaded("theoneprobe")) {
            // empty if block
        }
    }
}

