/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.compatibility.hudinfo.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.platform.compatibility.hudinfo.BalmModSupportHudInfo;
import net.blay09.mods.balm.platform.compatibility.hudinfo.BlockInfoProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;

public class CommonBalmModSupportHudInfo
implements BalmModSupportHudInfo {
    private final List<BlockInfoProvider> globalBlockInfoProviders = Collections.synchronizedList(new ArrayList());
    private final List<Pair<Supplier<Block>, BlockInfoProvider>> deferredBlockInfoProviders = Collections.synchronizedList(new ArrayList());
    private final Multimap<Block, BlockInfoProvider> blockInfoProviders = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    @Override
    public void registerGlobalBlockInfo(Identifier identifier, BlockInfoProvider provider) {
        this.globalBlockInfoProviders.add(provider);
    }

    @Override
    public void registerBlockInfo(Identifier identifier, Supplier<Block> block, BlockInfoProvider provider) {
        this.deferredBlockInfoProviders.add((Pair<Supplier<Block>, BlockInfoProvider>)Pair.of(block, (Object)provider));
    }

    public List<BlockInfoProvider> getBlockInfoProviders(Block block) {
        for (Pair<Supplier<Block>, BlockInfoProvider> deferredBlockInfoProvider : this.deferredBlockInfoProviders) {
            this.blockInfoProviders.put((Object)((Block)((Supplier)deferredBlockInfoProvider.getFirst()).get()), (Object)((BlockInfoProvider)deferredBlockInfoProvider.getSecond()));
        }
        this.deferredBlockInfoProviders.clear();
        ArrayList<BlockInfoProvider> result = new ArrayList<BlockInfoProvider>();
        result.addAll(this.blockInfoProviders.get((Object)block));
        result.addAll(this.globalBlockInfoProviders);
        return result;
    }
}

