/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.internal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.blay09.mods.balm.platform.config.internal.LenientEnumCodecs;
import net.blay09.mods.balm.platform.config.schema.builder.BooleanConfigProperty;
import net.blay09.mods.balm.platform.config.schema.builder.DoubleConfigProperty;
import net.blay09.mods.balm.platform.config.schema.builder.FloatConfigProperty;
import net.blay09.mods.balm.platform.config.schema.builder.IntConfigProperty;
import net.blay09.mods.balm.platform.config.schema.builder.LongConfigProperty;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public class PrimitiveConfigCodecs {
    public static <T> Codec<T> codec(Class<T> type) {
        if (type == String.class) {
            return Codec.STRING;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return IntConfigProperty.CODEC;
        }
        if (type == Long.class || type == Long.TYPE) {
            return LongConfigProperty.CODEC;
        }
        if (type == Float.class || type == Float.TYPE) {
            return FloatConfigProperty.CODEC;
        }
        if (type == Double.class || type == Double.TYPE) {
            return DoubleConfigProperty.CODEC;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BooleanConfigProperty.CODEC;
        }
        if (type == Identifier.class) {
            return Identifier.CODEC;
        }
        if (type.isEnum() && StringRepresentable.class.isAssignableFrom(type)) {
            return PrimitiveConfigCodecs.enumCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> Codec<T> enumCodec(Class<T> type) {
        return LenientEnumCodecs.fromValues(type::getEnumConstants);
    }

    public static <T> StreamCodec<ByteBuf, T> streamCodec(Class<T> type) {
        if (type == String.class) {
            return ByteBufCodecs.STRING_UTF8;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return ByteBufCodecs.INT;
        }
        if (type == Long.class || type == Long.TYPE) {
            return ByteBufCodecs.LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return ByteBufCodecs.FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return ByteBufCodecs.DOUBLE;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return ByteBufCodecs.BOOL;
        }
        if (type == Identifier.class) {
            return Identifier.STREAM_CODEC;
        }
        if (type.isEnum() && StringRepresentable.class.isAssignableFrom(type)) {
            return PrimitiveConfigCodecs.enumStreamCodec(type);
        }
        throw new IllegalArgumentException("Unsupported nested type: " + type.getName());
    }

    private static <T extends Enum<T>> StreamCodec<ByteBuf, T> enumStreamCodec(Class<T> type) {
        IntFunction byIdMapper = ByIdMap.continuous(rec$ -> ((Enum)rec$).ordinal(), (Object[])((Enum[])type.getEnumConstants()), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        return ByteBufCodecs.idMapper((IntFunction)byIdMapper, rec$ -> ((Enum)rec$).ordinal());
    }
}

