/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.event.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.platform.event.BidirectionalEventMapper;
import net.blay09.mods.balm.platform.event.EventMapper;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class EventMapperImpl<TCallback>
implements EventMapper<TCallback>,
BidirectionalEventMapper<TCallback> {
    private final String name;
    private @Nullable Supplier<TCallback> invoker;
    private @Nullable BiConsumer<Identifier, TCallback> registrar;

    public EventMapperImpl(String name) {
        this.name = name;
    }

    @Override
    public void register(TCallback listener) {
        this.register(EventPhases.DEFAULT, listener);
    }

    @Override
    public void register(Identifier phase, TCallback listener) {
        if (this.registrar == null) {
            throw new IllegalStateException("Event has not been bound.");
        }
        this.registrar.accept(phase, listener);
    }

    @Override
    public TCallback invoker() {
        if (this.invoker == null) {
            throw new IllegalStateException("Event cannot be invoked.");
        }
        return this.invoker.get();
    }

    @Override
    public void configureMapping(BiConsumer<Identifier, TCallback> registrar) {
        this.registrar = registrar;
    }

    @Override
    public void configureMapping(BiConsumer<Identifier, TCallback> registrar, Supplier<TCallback> invoker) {
        this.registrar = registrar;
        this.invoker = invoker;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public EventMapper<TCallback> filter(String name, Function<TCallback, TCallback> filter) {
        EventMapper<Object> mapper = EventMapper.createUnbound(this.name() + "(" + name + ")");
        mapper.configureMapping((phase, it) -> this.register((Identifier)phase, (TCallback)filter.apply(it)));
        return mapper;
    }
}

