/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.level.block.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.world.level.block.BalmBlockRegistrar;
import net.blay09.mods.balm.world.level.block.BalmBlockRegistration;
import net.blay09.mods.balm.world.level.block.BalmDiscriminatedBlockRegistration;
import net.blay09.mods.balm.world.level.block.DeferredBlock;
import net.blay09.mods.balm.world.level.block.DiscriminatedBlocks;
import net.blay09.mods.balm.world.level.block.internal.DeferredBlockImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jspecify.annotations.Nullable;

public class BalmBlockRegistrarImpl
implements BalmBlockRegistrar {
    private final BalmRegistrar registrar;
    private final String namespace;

    public BalmBlockRegistrarImpl(BalmRegistrar registrar, String namespace) {
        this.registrar = registrar;
        this.namespace = namespace;
    }

    @Override
    public BalmBlockRegistration register(String name, Function<BlockBehaviour.Properties, Block> constructor, Supplier<BlockBehaviour.Properties> properties) {
        Identifier identifier = Identifier.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)identifier);
        Holder<Block> holder = this.registrar.register(resourceKey, id -> (Block)constructor.apply(((BlockBehaviour.Properties)properties.get()).setId(resourceKey)));
        return new BalmBlockRegistrationImpl(this.registrar, holder);
    }

    @Override
    public <T> BalmDiscriminatedBlockRegistration<T> registerDiscriminated(Set<@Nullable T> values, Function<@Nullable T, String> nameFunction, BiFunction<@Nullable T, // Could not load outer class - annotation placement on inner may be incorrect
    BlockBehaviour.Properties, Block> constructor, BiFunction<@Nullable T, // Could not load outer class - annotation placement on inner may be incorrect
    BlockBehaviour.Properties, // Could not load outer class - annotation placement on inner may be incorrect
    BlockBehaviour.Properties> propertiesFunction) {
        BalmDiscriminatedBlockRegistrationImpl map = new BalmDiscriminatedBlockRegistrationImpl();
        for (Object value : values) {
            String name = nameFunction.apply(value);
            BalmBlockRegistration registration = this.register(name, (BlockBehaviour.Properties properties) -> (Block)constructor.apply(value, (BlockBehaviour.Properties)properties), (BlockBehaviour.Properties properties) -> (BlockBehaviour.Properties)propertiesFunction.apply(value, (BlockBehaviour.Properties)properties));
            map.put(value, registration);
        }
        return map;
    }

    private static final class BalmBlockRegistrationImpl
    implements BalmBlockRegistration {
        private final BalmRegistrar registrar;
        private final Holder<Block> holder;
        private @Nullable DeferredBlock deferredBlock;

        private BalmBlockRegistrationImpl(BalmRegistrar registrar, Holder<Block> holder) {
            this.registrar = registrar;
            this.holder = holder;
        }

        @Override
        public BalmBlockRegistration withItem(BiFunction<Block, Item.Properties, BlockItem> constructor, Supplier<Item.Properties> properties) {
            ResourceKey blockResourceKey = (ResourceKey)this.holder.unwrapKey().orElseThrow();
            ResourceKey itemResourceKey = ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)blockResourceKey.identifier());
            this.registrar.register(itemResourceKey, id -> (Item)constructor.apply((Block)this.holder.value(), ((Item.Properties)properties.get()).setId(itemResourceKey)));
            return this;
        }

        @Override
        public Holder<Block> asHolder() {
            return this.holder;
        }

        @Override
        public DeferredBlock asDeferredBlock() {
            if (this.deferredBlock == null) {
                this.deferredBlock = new DeferredBlockImpl(this.holder);
            }
            return this.deferredBlock;
        }
    }

    private static class BalmDiscriminatedBlockRegistrationImpl<T>
    extends HashMap<T, BalmBlockRegistration>
    implements BalmDiscriminatedBlockRegistration<T> {
        private BalmDiscriminatedBlockRegistrationImpl() {
        }

        @Override
        public DiscriminatedBlocks<T> asDiscriminatedBlocks() {
            DiscriminatedBlocksImpl map = new DiscriminatedBlocksImpl();
            this.forEach((key, registration) -> map.put(key, registration.asDeferredBlock()));
            return map;
        }
    }

    private static class DiscriminatedBlocksImpl<T>
    extends HashMap<T, DeferredBlock>
    implements DiscriminatedBlocks<T> {
        private DiscriminatedBlocksImpl() {
        }

        @Override
        public Stream<Map.Entry<T, DeferredBlock>> filterNonNullDiscriminatorEntries() {
            return this.entrySet().stream().filter(it -> it.getKey() != null);
        }

        @Override
        public Stream<DeferredBlock> filterNonNullDiscriminators() {
            return this.entrySet().stream().filter(it -> it.getKey() != null).map(Map.Entry::getValue);
        }
    }
}

