/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import org.jspecify.annotations.Nullable;

public class BackpackTintSources {
    public static void register(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(SophisticatedBackpacks.getIdentifier("main"), Main.MAP_CODEC);
        event.register(SophisticatedBackpacks.getIdentifier("accent"), Accent.MAP_CODEC);
    }

    public record Main(int defaultColor) implements ItemTintSource
    {
        public static final MapCodec<Main> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.RGB_COLOR_CODEC.fieldOf("default").forGetter(Main::defaultColor)).apply((Applicative)instance, Main::new));

        public Main(int defaultColor) {
            this.defaultColor = ARGB.opaque((int)defaultColor);
        }

        public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
            return BackpackWrapper.fromStack(itemStack).getMainColor();
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }

    public record Accent(int defaultColor) implements ItemTintSource
    {
        public static final MapCodec<Accent> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.RGB_COLOR_CODEC.fieldOf("default").forGetter(Accent::defaultColor)).apply((Applicative)instance, Accent::new));

        public Accent(int defaultColor) {
            this.defaultColor = ARGB.opaque((int)defaultColor);
        }

        public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
            return BackpackWrapper.fromStack(itemStack).getAccentColor();
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }
}

