/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncClientInfoPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.jspecify.annotations.Nullable;

public abstract class BackpackContext {
    public static final String SUBBACKPACK_DISPLAY_NAME_PREFIX = "... > ";

    public abstract Optional<IStorageWrapper> getParentBackpackWrapper(Player var1);

    public abstract boolean shouldLockBackpackSlot(Player var1);

    public abstract IBackpackWrapper getBackpackWrapper(Player var1);

    public abstract int getBackpackSlotIndex();

    public abstract BackpackContext getSubBackpackContext(int var1, boolean var2);

    public abstract BackpackContext getParentBackpackContext();

    public abstract ContextType getType();

    public void toBuffer(FriendlyByteBuf buffer) {
        this.getType().toBuffer(buffer);
        this.addToBuffer(buffer);
    }

    public abstract void addToBuffer(FriendlyByteBuf var1);

    public abstract boolean canInteractWith(Player var1);

    public BlockPos getBackpackPosition(Player playerEntity) {
        return playerEntity.blockPosition();
    }

    public Component getDisplayName(Player player) {
        return this.getBackpackWrapper(player).getBackpack().getHoverName();
    }

    public abstract void onUpgradeChanged(Player var1);

    public Optional<Entity> getOwnerPlayer(Player player) {
        return Optional.of(player);
    }

    public static BackpackContext fromBuffer(FriendlyByteBuf buffer, Level level) {
        ContextType type = ContextType.fromBuffer(buffer);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Block.fromBuffer(buffer);
            case 1 -> BlockSubBackpack.fromBuffer(buffer);
            case 3 -> ItemSubBackpack.fromBuffer(buffer);
            case 2 -> Item.fromBuffer(buffer);
            case 4 -> AnotherPlayer.fromBuffer(buffer, level);
            case 5 -> AnotherPlayerSubBackpack.fromBuffer(buffer, level);
        };
    }

    public boolean wasOpenFromInventory() {
        return false;
    }

    public boolean shouldSaveAfterOpen() {
        return false;
    }

    public void saveBackpackStack() {
    }

    public static enum ContextType {
        BLOCK_BACKPACK(0),
        BLOCK_SUB_BACKPACK(1),
        ITEM_BACKPACK(2),
        ITEM_SUB_BACKPACK(3),
        ANOTHER_PLAYER_BACKPACK(4),
        ANOTHER_PLAYER_SUB_BACKPACK(5);

        private final int id;
        private static final Map<Integer, ContextType> ID_CONTEXTS;

        private ContextType(int id) {
            this.id = id;
        }

        public void toBuffer(FriendlyByteBuf buffer) {
            buffer.writeShort(this.id);
        }

        public static ContextType fromBuffer(FriendlyByteBuf buffer) {
            return ID_CONTEXTS.getOrDefault(buffer.readShort(), ITEM_BACKPACK);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (ContextType value : ContextType.values()) {
                builder.put((Object)value.id, (Object)value);
            }
            ID_CONTEXTS = builder.build();
        }
    }

    public static class Block
    extends BackpackContext {
        protected final BlockPos pos;

        public Block(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public BlockPos getBackpackPosition(Player playerEntity) {
            return this.pos;
        }

        @Override
        public void onUpgradeChanged(Player player) {
            if (!player.level().isClientSide()) {
                WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)this.pos, BackpackBlockEntity.class).ifPresent(BackpackBlockEntity::refreshRenderState);
            }
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)this.pos, BackpackBlockEntity.class).map(BackpackBlockEntity::getBackpackWrapper).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return -1;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex, boolean saveAfterOpen) {
            return new BlockSubBackpack(this.pos, subBackpackSlotIndex, saveAfterOpen);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer) {
            return new Block(BlockPos.of((long)buffer.readLong()));
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            buffer.writeLong(this.pos.asLong());
        }

        @Override
        public boolean canInteractWith(Player player) {
            return player.level().getBlockEntity(this.pos) instanceof BackpackBlockEntity && player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_BACKPACK;
        }

        @Override
        public Optional<Entity> getOwnerPlayer(Player player) {
            return Optional.empty();
        }
    }

    public static class BlockSubBackpack
    extends Block {
        private final int subBackpackSlotIndex;
        private final boolean saveAfterOpen;
        private @Nullable IStorageWrapper parentWrapper;

        public BlockSubBackpack(BlockPos pos, int subBackpackSlotIndex, boolean saveAfterOpen) {
            super(pos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
            this.saveAfterOpen = saveAfterOpen;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(player).map(parent -> {
                ItemStack stackInSlot = parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex);
                if (!(stackInSlot.getItem() instanceof BackpackItem)) {
                    return IBackpackWrapper.Noop.INSTANCE;
                }
                return BackpackWrapper.fromStack(stackInSlot);
            }).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer) {
            return new BlockSubBackpack(BlockPos.of((long)buffer.readLong()), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            super.addToBuffer(buffer);
            buffer.writeInt(this.subBackpackSlotIndex);
            buffer.writeBoolean(this.saveAfterOpen);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Block(this.pos);
        }

        @Override
        public ContextType getType() {
            return ContextType.BLOCK_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.literal((String)(BackpackContext.SUBBACKPACK_DISPLAY_NAME_PREFIX + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }

        @Override
        public boolean shouldSaveAfterOpen() {
            return this.saveAfterOpen;
        }

        @Override
        public void saveBackpackStack() {
            if (this.parentWrapper != null) {
                this.parentWrapper.getInventoryHandler().setStackInSlot(this.subBackpackSlotIndex, this.parentWrapper.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex));
                this.parentWrapper.getInventoryHandler().saveInventory();
            }
        }
    }

    public static class ItemSubBackpack
    extends Item {
        private final int subBackpackSlotIndex;
        private final boolean saveAfterOpen;
        private @Nullable IStorageWrapper parentWrapper;

        public ItemSubBackpack(String handlerName, String identifier, int backpackSlotIndex, boolean parentOpenFromInventory, int subBackpackSlotIndex, boolean saveAfterOpen) {
            super(handlerName, identifier, backpackSlotIndex, parentOpenFromInventory);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
            this.saveAfterOpen = saveAfterOpen;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(player).map(parent -> {
                ItemStack stackInSlot = parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex);
                if (!(stackInSlot.getItem() instanceof BackpackItem)) {
                    return IBackpackWrapper.Noop.INSTANCE;
                }
                return BackpackWrapper.fromStack(stackInSlot);
            }).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer) {
            return new ItemSubBackpack(buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readBoolean(), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            super.addToBuffer(buffer);
            buffer.writeInt(this.subBackpackSlotIndex);
            buffer.writeBoolean(this.saveAfterOpen);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Item(this.handlerName, this.identifier, this.backpackSlotIndex, super.wasOpenFromInventory());
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.literal((String)(BackpackContext.SUBBACKPACK_DISPLAY_NAME_PREFIX + super.getDisplayName(player).getString()));
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }

        @Override
        public boolean shouldSaveAfterOpen() {
            return this.saveAfterOpen;
        }

        @Override
        public void saveBackpackStack() {
            if (this.parentWrapper != null) {
                this.parentWrapper.getInventoryHandler().setStackInSlot(this.subBackpackSlotIndex, this.parentWrapper.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex));
                this.parentWrapper.getInventoryHandler().saveInventory();
            }
        }
    }

    public static class Item
    extends BackpackContext {
        protected final String handlerName;
        protected final String identifier;
        protected final int backpackSlotIndex;
        private final boolean openFromInventory;

        public Item(String handlerName, int backpackSlotIndex) {
            this(handlerName, "", backpackSlotIndex);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex) {
            this(handlerName, identifier, backpackSlotIndex, false);
        }

        public Item(String handlerName, String identifier, int backpackSlotIndex, boolean openFromInventory) {
            this.handlerName = handlerName;
            this.identifier = identifier;
            this.backpackSlotIndex = backpackSlotIndex;
            this.openFromInventory = openFromInventory;
        }

        @Override
        public boolean wasOpenFromInventory() {
            return this.openFromInventory;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName).map(PlayerInventoryHandler::isVisibleInGui).orElse(false);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            Optional<PlayerInventoryHandler> inventoryHandler = PlayerInventoryProvider.get().getPlayerInventoryHandler(this.handlerName);
            if (inventoryHandler.isEmpty()) {
                SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Unable to find inventory handler for \"{}\"", (Object)this.handlerName);
                return IBackpackWrapper.Noop.INSTANCE;
            }
            ItemStack backpackStack = inventoryHandler.get().getStackInSlot(player, this.identifier, this.backpackSlotIndex);
            if (backpackStack.getItem() instanceof BackpackItem) {
                return BackpackWrapper.fromStack(backpackStack);
            }
            SophisticatedBackpacks.LOGGER.error("Error getting backpack wrapper - Stack isn't a backpack");
            return IBackpackWrapper.Noop.INSTANCE;
        }

        @Override
        public void onUpgradeChanged(Player player) {
            if (!player.level().isClientSide() && this.handlerName.equals("main")) {
                IBackpackWrapper backpackWrapper = this.getBackpackWrapper(player);
                RenderData modificationSafeRenderData = backpackWrapper.getRenderDataHandler().getData().copy();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncClientInfoPayload(this.backpackSlotIndex, modificationSafeRenderData, backpackWrapper.getColumnsTaken()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @Override
        public int getBackpackSlotIndex() {
            return this.backpackSlotIndex;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex, boolean saveAfterOpen) {
            return new ItemSubBackpack(this.handlerName, this.identifier, this.backpackSlotIndex, this.openFromInventory, subBackpackSlotIndex, saveAfterOpen);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        @Override
        public ContextType getType() {
            return ContextType.ITEM_BACKPACK;
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer) {
            return new Item(buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.handlerName);
            buffer.writeUtf(this.identifier);
            buffer.writeInt(this.backpackSlotIndex);
            buffer.writeBoolean(this.openFromInventory);
        }

        @Override
        public boolean canInteractWith(Player player) {
            return true;
        }
    }

    public static class AnotherPlayer
    extends Item {
        protected final Player otherPlayer;

        public AnotherPlayer(String handlerName, String identifier, int backpackSlotIndex, Player otherPlayer) {
            super(handlerName, identifier, backpackSlotIndex);
            this.otherPlayer = otherPlayer;
        }

        @Override
        public boolean shouldLockBackpackSlot(Player player) {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return super.getBackpackWrapper(this.otherPlayer);
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex, boolean saveAfterOpen) {
            return new AnotherPlayerSubBackpack(this.otherPlayer, this.handlerName, this.identifier, this.backpackSlotIndex, subBackpackSlotIndex, saveAfterOpen);
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            buffer.writeInt(this.otherPlayer.getId());
            buffer.writeUtf(this.handlerName);
            buffer.writeUtf(this.identifier);
            buffer.writeInt(this.backpackSlotIndex);
        }

        @Override
        public boolean canInteractWith(Player player) {
            return player.distanceTo((Entity)this.otherPlayer) < 8.0f;
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return super.getDisplayName(this.otherPlayer);
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer, Level level) {
            int playerId = buffer.readInt();
            Player otherPlayer = (Player)level.getEntity(playerId);
            return new AnotherPlayer(buffer.readUtf(), buffer.readUtf(), buffer.readInt(), Objects.requireNonNull(otherPlayer));
        }

        @Override
        public Optional<Entity> getOwnerPlayer(Player player) {
            return Optional.of(this.otherPlayer);
        }
    }

    public static class AnotherPlayerSubBackpack
    extends AnotherPlayer {
        private final int subBackpackSlotIndex;
        private final boolean saveAfterOpen;
        private @Nullable IStorageWrapper parentWrapper;

        public AnotherPlayerSubBackpack(Player otherPlayer, String handlerName, String identifier, int backpackSlotIndex, int subBackpackSlotIndex, boolean saveAfterOpen) {
            super(handlerName, identifier, backpackSlotIndex, otherPlayer);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
            this.saveAfterOpen = saveAfterOpen;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(Player player) {
            return this.getParentBackpackWrapper(this.otherPlayer).map(parent -> BackpackWrapper.fromExistingData(parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex)).orElse(IBackpackWrapper.Noop.INSTANCE)).orElse(IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            super.addToBuffer(buffer);
            buffer.writeInt(this.subBackpackSlotIndex);
            buffer.writeBoolean(this.saveAfterOpen);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new AnotherPlayer(this.handlerName, this.identifier, this.backpackSlotIndex, this.otherPlayer);
        }

        @Override
        public ContextType getType() {
            return ContextType.ANOTHER_PLAYER_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(Player player) {
            return Component.literal((String)(BackpackContext.SUBBACKPACK_DISPLAY_NAME_PREFIX + super.getDisplayName(player).getString()));
        }

        public static BackpackContext fromBuffer(FriendlyByteBuf buffer, Level level) {
            int playerId = buffer.readInt();
            Player otherPlayer = (Player)level.getEntity(playerId);
            return new AnotherPlayerSubBackpack(Objects.requireNonNull(otherPlayer), buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        }

        @Override
        public void onUpgradeChanged(Player player) {
        }

        @Override
        public boolean shouldSaveAfterOpen() {
            return this.saveAfterOpen;
        }

        @Override
        public void saveBackpackStack() {
            if (this.parentWrapper != null) {
                this.parentWrapper.getInventoryHandler().setStackInSlot(this.subBackpackSlotIndex, this.parentWrapper.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex));
                this.parentWrapper.getInventoryHandler().saveInventory();
            }
        }
    }
}

