/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.common;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static <R> void addRecipes(IRecipeDisplayGenerator<R> generator) {
        DyeRecipesMaker.addSingleColorRecipes(generator);
        DyeRecipesMaker.addMultipleColorsRecipe(generator);
    }

    private static <R> void addMultipleColorsRecipe(IRecipeDisplayGenerator<R> generator) {
        int clothColor = ColorHelper.calculateColor((int)-3382982, (int)-3382982, List.of(DyeColor.YELLOW, DyeColor.LIME));
        int trimColor = ColorHelper.calculateColor((int)-10342886, (int)-10342886, List.of(DyeColor.BLUE, DyeColor.BLACK));
        ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
        BackpackWrapper.fromStack(backpackOutput).setColors(clothColor, trimColor);
        generator.shaped(backpackOutput).pattern("YB ").pattern("LEA").define(Character.valueOf('Y'), DyeColor.YELLOW.getTag()).define(Character.valueOf('B'), (ItemLike)ModItems.BACKPACK.get()).define(Character.valueOf('L'), DyeColor.LIME.getTag()).define(Character.valueOf('E'), DyeColor.BLUE.getTag()).define(Character.valueOf('A'), DyeColor.BLACK.getTag()).save(ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)Identifier.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"multiple_colors")));
    }

    private static <R> void addSingleColorRecipes(IRecipeDisplayGenerator<R> generator) {
        for (DyeColor color : DyeColor.values()) {
            ItemStack backpackOutput = new ItemStack((ItemLike)ModItems.BACKPACK.get());
            BackpackWrapper.fromStack(backpackOutput).setColors(color.getTextureDiffuseColor(), color.getTextureDiffuseColor());
            generator.shaped(backpackOutput).pattern("D").pattern("B").define(Character.valueOf('D'), color.getTag()).define(Character.valueOf('B'), (ItemLike)ModItems.BACKPACK.get()).save(ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)Identifier.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)("single_color_" + color.getSerializedName()))));
        }
    }
}

