/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;

public record UpgradeTogglePayload(int upgradeSlot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpgradeTogglePayload> TYPE = new CustomPacketPayload.Type(SophisticatedBackpacks.getIdentifier("upgrade_toggle"));
    public static final StreamCodec<ByteBuf, UpgradeTogglePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, UpgradeTogglePayload::upgradeSlot, UpgradeTogglePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(UpgradeTogglePayload payload, IPayloadContext context) {
        Player player = context.player();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
            IUpgradeWrapper upgradeWrapper;
            Map slotWrappers = BackpackWrapper.fromStack(backpack).getUpgradeHandler().getSlotWrappers();
            if (slotWrappers.containsKey(payload.upgradeSlot) && (upgradeWrapper = (IUpgradeWrapper)slotWrappers.get(payload.upgradeSlot)).canBeDisabled()) {
                upgradeWrapper.setEnabled(!upgradeWrapper.isEnabled());
                String translKey = upgradeWrapper.isEnabled() ? "gui.sophisticatedbackpacks.status.upgrade_switched_on" : "gui.sophisticatedbackpacks.status.upgrade_switched_off";
                player.displayClientMessage((Component)Component.translatable((String)translKey, (Object[])new Object[]{upgradeWrapper.getUpgradeStack().getHoverName()}), true);
            }
            return true;
        });
    }
}

