/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.mixin;

import baguchan.revampedwolf.api.IHunger;
import baguchan.revampedwolf.api.IHunt;
import baguchan.revampedwolf.entity.goal.HuntTargetGoal;
import baguchan.revampedwolf.entity.goal.LeapAtTargetWolfGoal;
import baguchan.revampedwolf.entity.goal.MoveToMeatGoal;
import baguchan.revampedwolf.entity.goal.WolfAvoidEntityGoal;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.skeleton.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimal
implements NeutralMob,
IHunt,
IHunger {
    private int huntCooldown;
    private int eatTick;
    private int hungerTick;
    private float saturation;
    @Shadow
    @Final
    public static TargetingConditions.Selector PREY_SELECTOR;

    protected WolfMixin(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onConstructor(EntityType<? extends Wolf> p_27557_, Level p_27558_, CallbackInfo info) {
        this.setCanPickUpLoot(true);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void registerGoals(CallbackInfo callbackInfo) {
        Wolf wolf = (Wolf)this;
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(wolf, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetWolfGoal((Mob)this, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new MoveToMeatGoal(this));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new BegGoal(wolf, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((WolfMixin)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(5, new HuntTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        callbackInfo.cancel();
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/wolf/Wolf;heal(F)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void mobInteractHeal(Player p_406380_, InteractionHand p_406261_, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = p_406380_.getItemInHand(p_406261_);
        FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
        float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
        float f2 = foodproperties != null ? foodproperties.saturation() : 0.1f;
        this.saturation = Mth.clamp((float)(this.saturation + f * f2 * 2.0f), (float)0.0f, (float)20.0f);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void aiStep(CallbackInfo callbackInfo) {
        if (!this.level().isClientSide() && this.isAlive()) {
            if (this.hungerTick > 0) {
                --this.hungerTick;
            }
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && this.getItemInHand(InteractionHand.MAIN_HAND).get(DataComponents.FOOD) != null && this.getItemInHand(InteractionHand.MAIN_HAND).is(ItemTags.WOLF_FOOD)) {
                if (this.getHealth() < this.getMaxHealth() || !this.isTame()) {
                    ++this.eatTick;
                    if (this.eatTick > 200 && !mainhand.isEmpty()) {
                        this.startUsingItem(InteractionHand.MAIN_HAND);
                    }
                }
            } else {
                this.eatTick = 0;
            }
        }
        if (this.getHealth() < this.getMaxHealth() && this.saturation > 0.0f) {
            this.saturation = Mth.clamp((float)(this.saturation - 0.5f), (float)0.0f, (float)20.0f);
            if (this.saturation >= 0.5f) {
                this.heal(1.0f);
            }
        }
    }

    protected void completeUsingItem() {
        ItemStack copy;
        InteractionHand hand = this.getUsedItemHand();
        if (this.useItem.equals(this.getItemInHand(hand)) && !this.useItem.isEmpty() && this.isUsingItem() && (copy = this.useItem.copy()).get(DataComponents.FOOD) != null) {
            FoodProperties foodproperties = (FoodProperties)copy.get(DataComponents.FOOD);
            float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
            float f2 = foodproperties != null ? foodproperties.saturation() : 0.1f;
            this.heal(f);
            this.saturation = Mth.clamp((float)(this.saturation + f * f2 * 2.0f), (float)0.0f, (float)20.0f);
        }
        super.completeUsingItem();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide()) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() && p_28578_.is(ItemTags.WOLF_FOOD);
    }

    protected void pickUpItem(ServerLevel serverLevel, ItemEntity p_28514_) {
        ItemStack itemstack;
        if (!this.isTame() && this.canHoldItem(itemstack = p_28514_.getItem())) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.setDropChance(EquipmentSlot.MAINHAND, 2.0f);
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.eatTick = 0;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void addAdditionalSaveData(ValueOutput p_422504_, CallbackInfo ci) {
        p_422504_.putInt("HuntingCooldown", this.huntCooldown);
        p_422504_.putInt("EatTick", this.eatTick);
        p_422504_.putInt("HungerTick", this.hungerTick);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void readAdditionalSaveData(ValueInput p_421669_, CallbackInfo ci) {
        this.huntCooldown = p_421669_.getIntOr("HuntingCooldown", 0);
        this.eatTick = p_421669_.getIntOr("EatTick", 0);
        this.hungerTick = p_421669_.getIntOr("HungerTick", 0);
        this.setCanPickUpLoot(true);
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_, DamageSource p_432749_) {
        this.setHuntCooldown(1200);
        return super.killedEntity(p_216988_, p_216989_, p_432749_);
    }

    @Override
    public void setHuntCooldown(int cooldown) {
        this.huntCooldown = cooldown;
    }

    @Override
    public int getHuntCooldown() {
        return this.huntCooldown;
    }

    @Override
    public boolean isHunted() {
        return this.huntCooldown > 0;
    }

    @Override
    public int getHunger() {
        return this.hungerTick;
    }

    @Override
    public void setHunger(int hunger) {
        this.hungerTick = hunger;
    }
}

